/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Plan;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;

public final class ViewMemo {
    private static int BLOC = 64;
    protected ViewMemoItem[] memo;
    private int nb = 0;

    protected ViewMemo() {
    }

    protected int size() {
        return this.nb;
    }

    protected ViewMemo copy() {
        ViewMemo vm = new ViewMemo();
        vm.memo = new ViewMemoItem[this.memo.length];
        vm.nb = this.nb;
        for (int i = 0; i < this.nb; ++i) {
            vm.memo[i] = this.memo[i].copy();
        }
        return vm;
    }

    private void fixeNb() {
    }

    private void extension(int i) {
        if (this.memo == null || this.memo.length <= i) {
            ViewMemoItem[] nmemo = new ViewMemoItem[i + BLOC];
            if (this.memo != null) {
                System.arraycopy(this.memo, 0, nmemo, 0, this.memo.length);
            }
            this.memo = nmemo;
        }
    }

    protected void set(int i, ViewSimple v) {
        this.extension(i);
        ViewMemoItem viewMemoItem = this.memo[i] = v == null ? null : new ViewMemoItem(v);
        if (i >= this.nb) {
            this.nb = i + 1;
        }
    }

    protected void set(int i, ViewMemoItem vmi) {
        this.extension(i);
        this.memo[i] = vmi;
        if (i >= this.nb) {
            this.nb = i + 1;
        }
    }

    protected void cale(int n) {
        for (int i = n; i < this.nb; ++i) {
            this.memo[i - 1] = this.memo[i];
        }
        this.memo[--this.nb] = null;
    }

    protected void decale(int n) {
        this.set(this.nb, (ViewSimple)null);
        for (int i = this.nb - 1; i > n; --i) {
            this.memo[i] = this.memo[i - 1];
        }
        this.memo[n] = null;
    }

    protected boolean isUsed(Plan p) {
        return this.find(p, 0) != -1;
    }

    protected int find(Plan p, int first) {
        int i = 0;
        while (i < this.nb) {
            if (first == this.nb) {
                first = 0;
            }
            if (this.memo[first] != null && this.memo[first].pref == p) {
                return first;
            }
            ++i;
            ++first;
        }
        return -1;
    }

    protected int getLastUsed() {
        int j = -1;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref == null) continue;
            j = i;
        }
        return j;
    }

    protected int getNbUsed() {
        int j = 0;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref == null) continue;
            ++j;
        }
        return j;
    }

    protected int setAfter(int i, ViewSimple v) {
        ++i;
        while (i < this.nb && this.memo[i] != null && this.memo[i].pref != null) {
            ++i;
        }
        this.set(i, v);
        return i;
    }

    protected ViewSimple get(int i, ViewSimple v) {
        if (v == null || i >= this.nb || this.memo[i] == null) {
            return null;
        }
        return this.memo[i].get(v);
    }

    protected void free(int i) {
        if (i < this.memo.length) {
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected void freeAll() {
        for (int i = 0; i < this.nb; ++i) {
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected void freeLock() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].locked) continue;
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected boolean hasLock() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].locked) continue;
            return true;
        }
        return false;
    }

    protected void freeSelected() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].selected) continue;
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected boolean freeRef(Plan pref) {
        boolean rep = false;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref != pref) continue;
            rep = true;
            this.memo[i] = null;
        }
        this.fixeNb();
        return rep;
    }
}

